/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.FSPCmdMgr;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;

public class FspVspCmds {
    private static FspVspCmds mInst;
    private static final String GET_SRC_FROM_SEQUENCE_NUMBER = "GET_SRC_FROM_SEQUENCE_NUMBER";
    private static final String GET_CURRENT_SRC_AND_SEQUENCE_NUMBER = "GET_CURRENT_SRC_AND_SEQUENCE_NUMBER";
    private static final String POWER_ON = "POWER_ON";
    private static final String POWER_OFF = "POWER_OFF";
    private static final String PUSH_VIRTUAL_PANEL_FUNCTION = "PUSH_VIRTUAL_PANEL_FUNCTION";
    private static final String GET_SUPPORTED_VIRTUAL_PANEL_FUNCTIONS = "GET_SUPPORTED_VIRTUAL_PANEL_FUNCTIONS";
    private static final String FUNCTIONS = "FUNCTIONS";
    private static final String VSP_ASYNC_ACKNOWLEDGE = "VSP_ASYNC_ACKNOWLEDGE";
    private static final String VSP_SRC_ASYNC_ACKNOWLEDGE = "VSP_SRC_ASYNC_ACKNOWLEDGE";
    private static final String INIT_FIRE_HOSE_DUMP = "INIT_FIRE_HOSE_DUMP";
    private static final String GET_VSP_CAPABILITIES = "GET_VSP_CAPABILITIES";

    static FspVspCmds getInstance() {
        if (mInst == null) {
            mInst = new FspVspCmds();
        }
        return mInst;
    }

    private FspVspCmds() {
    }

    Hashtable getSrcCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt32 unsignedInt32) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        hashtable = unsignedInt32 != null ? fSPCmdMgr.doPhypCommand(GET_SRC_FROM_SEQUENCE_NUMBER, new String[]{unsignedInt16.toString(), unsignedInt32.toString()}) : fSPCmdMgr.doPhypCommand(GET_CURRENT_SRC_AND_SEQUENCE_NUMBER, new String[]{unsignedInt16.toString()});
        return hashtable;
    }

    void powerOnPartitionCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16) throws PIHscServerException, PIHscCmdMgrException {
        fSPCmdMgr.doPhypCommand(POWER_ON, new String[]{unsignedInt16.toString()});
    }

    void powerOffPartitionCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16) throws PIHscServerException, PIHscCmdMgrException {
        fSPCmdMgr.doPhypCommand(POWER_OFF, new String[]{unsignedInt16.toString()});
    }

    void pushVirtualPanelFuncCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, String string) throws PIHscServerException, PIHscCmdMgrException {
        fSPCmdMgr.doPhypCommand(PUSH_VIRTUAL_PANEL_FUNCTION, new String[]{unsignedInt16.toString(), string});
    }

    byte[] getSupportedVirtualPanelFuncCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_SUPPORTED_VIRTUAL_PANEL_FUNCTIONS, new String[]{unsignedInt16.toString()});
        return (byte[])hashtable.get(FUNCTIONS);
    }

    void vspAsyncAcknowledgeCmd(FSPCmdMgr fSPCmdMgr, byte[] byArray) throws PIHscServerException {
        fSPCmdMgr.doPhypCommand(VSP_ASYNC_ACKNOWLEDGE, null, 0, byArray, null, null, null, null);
    }

    void vspSrcAsyncAcknowledgeCmd(FSPCmdMgr fSPCmdMgr, byte[] byArray) throws PIHscServerException {
        fSPCmdMgr.doPhypCommand(VSP_SRC_ASYNC_ACKNOWLEDGE, null, 0, byArray, null, null, null, null);
    }

    void initFireHoseDump(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16) throws PIHscServerException {
        fSPCmdMgr.doPhypCommand(INIT_FIRE_HOSE_DUMP, new String[]{unsignedInt16.toString()});
    }

    void exchangeVspCapabilitiesCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException {
        try {
            fSPCmdMgr.doPhypCommand(GET_VSP_CAPABILITIES, new String[]{"4", "-2147483648"});
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

